<!DOCTYPE html>
<html
  lang="{{ $lang }}"
  dir="{{ $lang === 'ar' ? 'rtl' : 'ltr' }}"
  x-data="{
      ...Object.assign(navbar(), submenuData()),

      // 🌙 الثيم
      darkMode: window.appSettings?.dark_mode ?? false,
      toggleTheme() {
          this.darkMode = !this.darkMode;
          localStorage.setItem('theme', this.darkMode ? 'dark' : 'light');
          @if (Auth::check()) fetch('{{ route('update.darkmode', ['id' => Auth::id()]) }}'); @endif
      },

      // 📚 اللغة والاتجاه
      dir: '{{ $lang === 'ar' ? 'rtl' : 'ltr' }}',
      switchLang() {
          const target = this.dir === 'rtl' ? 'en' : 'ar';
          localStorage.setItem('lang', target);
          this.dir = target === 'ar' ? 'rtl' : 'ltr';
          @if (Auth::check()) fetch(`{{ url('set-language') }}/${target}`); @endif
          setTimeout(() => window.location.reload(), 100);
      },

      // 📚 sidebar & navbar
      sidebarOpen: localStorage.getItem('sidebarOpen') === 'true',
      hidden: localStorage.getItem('navbarHidden') === 'true',
      toggleSidebar() {
          this.sidebarOpen = !this.sidebarOpen;
          localStorage.setItem('sidebarOpen', this.sidebarOpen);
      },
      toggleNavbar() {
          this.hidden = !this.hidden;
          localStorage.setItem('navbarHidden', this.hidden);
      }
  }"
  x-init="
      $el.setAttribute('dir', dir);
      $watch('dir', val => $el.setAttribute('dir', val));
      $watch('darkMode', val => localStorage.setItem('theme', val ? 'dark' : 'light'));
      $watch('sidebarOpen', val => localStorage.setItem('sidebarOpen', val));
      $watch('hidden', val => localStorage.setItem('navbarHidden', val));
  "
  x-bind:class="{ 'dark': darkMode }"
  x-bind:dir="dir"
>

<head>
    {{-- إعدادات عامة خاصة بالتطبيق --}}
    @include('components.global.settings')

    {{-- ضبط وضع الثيم الداكن فورًا --}}
    <script>

        document.documentElement.classList.toggle('dark', localStorage.getItem('theme') === 'dark');
    </script>

    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <title>{{ $title ?? 'Orascom' }}</title>

    {{-- خطوط --}}
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />

    {{-- ملفات Vite --}}
    @vite(['resources/css/backend/app.css', 'resources/js/app.js'])
</head>
